package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class MbrIntegralRegistrationAddRequestParam {

    @ApiModelProperty("会员code")
    @NotBlank
    private String mbrMembersCode;

    @ApiModelProperty("订单号")
    @NotBlank
    private String orderNo;

    @ApiModelProperty("下单时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @NotNull
    private LocalDateTime placeOrderTime;

    @ApiModelProperty("吊牌金额")
    @NotNull
    private BigDecimal tagAmount;

    @ApiModelProperty("订单金额")
    @NotNull
    private BigDecimal tradeAmount;

    @ApiModelProperty("支付金额")
    @NotNull
    private BigDecimal payMoney;

    @ApiModelProperty("商户编号")
    @NotBlank
    private String merchantNo;
}