package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class MbrFlightRecordFocusReq {

    @NotBlank(message = "会员code不能为空")
    @ApiModelProperty(value = "会员表code", example = "mbrMembersCode100", required = true)
    private String mbrMembersCode;

    @ApiModelProperty("航班信息code")
    private String basicFlightCode;

    @ApiModelProperty("中转旅客标识：1-中转，2-非中转")
    private String isTransit;

    @ApiModelProperty("航班信息code")
    private String transitBasicFlightCode;
}
