package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class MbrBenefitsLevelAddRequestParam {

    @NotNull
    @ApiModelProperty("会员权益code")
    private String mbrBenefitsCode;

    @ApiModelProperty("等级code")
    private String mbrLevelDefCode;

    @ApiModelProperty("等级名称")
    private String levelName;

    @ApiModelProperty("是否开启：1-开启，0-关闭")
    private Boolean status;

    @ApiModelProperty("权益领取方式：1-权益领取，2-链接跳转")
    private Integer claimMethod;

    @ApiModelProperty("权益类型：1-优惠券，2-积分")
    private Integer type;

    @ApiModelProperty("券定义code集合")
    private List<String> couponDefinitionCodeList;

    @ApiModelProperty("积分")
    private Integer integral;

    @ApiModelProperty("获取规则限制类型：1-日，2-周，3-月，4-年")
    private Integer limitType;

    @ApiModelProperty("获取规则限制次数")
    private Integer limitCount;

    @ApiModelProperty("链接类型：1-内部小程序，2-第三方小程序，3-H5")
    private Integer linkType;

    @ApiModelProperty("链接小程序appid，内部小程序为空")
    private String linkAppid;

    @ApiModelProperty("链接小程序名称，内部小程序为空")
    private String linkAppname;

    @ApiModelProperty("链接路径")
    private String linkUrl;

    @ApiModelProperty("链接路径名称")
    private String linkName;

    @ApiModelProperty("操作人code")
    private String userCode;

    @ApiModelProperty("操作人")
    private String userName;

}
