package com.bizvane.members.feign.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;


@Data
public class MbrGroupDefVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("分组code")
    private String mbrGroupDefCode;

    @ApiModelProperty("分组目录code")
    private String mbrGroupTypeDefCode;

    @ApiModelProperty("分组名称")
    private String groupName;

    @ApiModelProperty("分组条件")
    private String conditions;

    @ApiModelProperty("条件sql")
    private String sql;

    @ApiModelProperty("人群总数")
    private Integer crowdNumberTotal;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人id")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime modifiedDate;
}
