package com.bizvane.members.feign.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class CouponDefinitionVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("券编号")
    private String couponDefinitionCode;

    @ApiModelProperty("券所属机构编号")
    private String airportNoOrg;

    @ApiModelProperty("券生成渠道：1-crm生成，2-外部系统")
    private Integer generationChannel;

    @ApiModelProperty("外部系统券编码")
    private String externalSystemCouponCode;

    @ApiModelProperty("券名称")
    private String couponName;

    @ApiModelProperty("描述")
    private String info;

    @ApiModelProperty("优惠类型（1现金,2折扣,3兑换）")
    private Integer preferentialType;

    @ApiModelProperty("券的面额")
    private BigDecimal money;

    @ApiModelProperty("券的折扣")
    private BigDecimal discount;

    @ApiModelProperty("有效期类型：1-日期区间，2-领取后X天有效，3-仅限会员生日当天使用，4-仅限会员生日当月使用 5 领取后X天生效 效期X天")
    private Integer validType;

    @ApiModelProperty("有效期开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime validDateStart;

    @ApiModelProperty("有效期结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime validDateEnd;

    @ApiModelProperty("有效天数")
    private Integer validDay;

    @ApiModelProperty("最低消费金额(满减金额)")
    private BigDecimal minConsume;

    @ApiModelProperty("最高优惠金额")
    private BigDecimal maxPreferential;

    @ApiModelProperty("整单最低折扣限制")
    private BigDecimal minDiscount;

    @ApiModelProperty("是否允许转赠（1允许转赠，0不允许转赠）")
    private Boolean isTransfer;

    @ApiModelProperty("活动叠加条件：1-不允许叠加其他活动使用，2-允许叠加其他活动使用，3-允许部分活动使用")
    private Integer activitySuperpositionType;

    @ApiModelProperty("适用范围：1-业态，2-商户")
    private Integer scopeType;

    @ApiModelProperty("适用机场编号")
    private String scopeAirportNo;

    @ApiModelProperty("业态编号")
    private String scopeIndustryNoList;

    @ApiModelProperty("商户编号")
    private String scopeMerchantNoList;

    @ApiModelProperty("券模板图片")
    private String img;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("券状态（1已启用，0已停用）")
    private Boolean status;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime modifiedDate;

}
