package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

@NoArgsConstructor
@AllArgsConstructor
@Builder
@Data
public class MbrIntegralRegistrationReviewRequestParam {

    @ApiModelProperty("积分登记code")
    @NotBlank
    private String mbrIntegralRegistrationCode;

    @ApiModelProperty("状态：1-通过，2-不通过")
    @NotBlank
    private Integer status;

    @ApiModelProperty("赠送积分")
    @NotBlank
    private Integer giveIntegral;

    @ApiModelProperty("积分有效期天数")
    @NotBlank
    private Integer integralValidDay;

    @ApiModelProperty("审核说明")
    private String info;

    @ApiModelProperty("审核人code")
    private String userCode;

    @ApiModelProperty("审核人姓名")
    private String userName;
}