package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 券转增记录表
 * </p>
 *
 * @author Trump
 * @since 2024-09-24
 */
@Data
public class CouponTransferLogListRequestParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("券名称")
    private String couponName;

    @ApiModelProperty("券定义编号")
    private String couponDefinitionCode;

    @ApiModelProperty("券号")
    private String couponNo;

    @ApiModelProperty("券转赠记录code")
    private String couponTransferLogCode;

    @ApiModelProperty("券实例code")
    private String couponEntityCode;

    @ApiModelProperty("转赠人code")
    private String transferMemberCode;

    @ApiModelProperty("转赠人卡号")
    private String transferCardNo;

    @ApiModelProperty("转赠人手机号")
    private String transferPhone;

    @ApiModelProperty("被转赠人code")
    private String receivedMemberCode;

    @ApiModelProperty("被转赠人卡号")
    private String receivedCardNo;

    @ApiModelProperty("被转赠人手机号")
    private String receivedPhone;

    @ApiModelProperty("转赠状态：1-转增中，2-已完成，3-已撤回")
    private Integer giveStatus;

    @ApiModelProperty("操作时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime businessTimeStart;

    @ApiModelProperty("操作时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime businessTimeEnd;

    private int pageNum = 1;

    private int pageSize  = 10;
}
