package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CouponExternalRecordListRequestParam {

    @ApiModelProperty("外部券汇总表code")
    private String couponExternalSumCode;

    private List<String> couponExternalSumCodeList;

    @ApiModelProperty("券定义code")
    private String couponDefinitionCode;

    @ApiModelProperty("券号")
    private String couponNo;

    @ApiModelProperty("状态：false-不可用，true-可用")
    private Boolean status;

    @ApiModelProperty("状态：false-失败，true-成功")
    private Boolean importStatus;

    private int pageNum = 1;

    private int pageSize  = 10;

}
