package com.bizvane.members.feign.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 会员等级记录表
 * </p>
 *
 * @author Trump
 * @since 2024-10-04
 */
@Data
public class MbrLevelRecordVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("等级记录code")
    private String mbrLevelRecordCode;

    @ApiModelProperty("等级code")
    private String mbrLevelDefCode;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("会员手机号")
    private String phone;

    @ApiModelProperty("原等级")
    private Long originMbrLevelDefCode;

    @ApiModelProperty("当前等级")
    private Long currentMbrLevelDefCode;

    @ApiModelProperty("流水条件")
    private String conditions;

    @ApiModelProperty("操作类型：1-升级，2-降级")
    private Integer opsType;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDate;
}
