package com.bizvane.members.feign.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 
 * </p>
 *
 * @author Trump
 * @since 2024-09-13
 */
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class MbrLabelRecordVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("code")
    private String mbrLabelRecordLabelCode;

    @ApiModelProperty("标签定义code")
    private String mbrLabelDefCode;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("会员名称")
    private String name;

    @ApiModelProperty("标签名称")
    private String labelName;

    @ApiModelProperty("操作标签类型 1帖标签 2撕标签")
    private Integer operateType;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDate;
}
