package com.bizvane.members.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 会员权益等级表
 * </p>
 *
 * @author Trump
 * @since 2024-10-04
 */
@Data
public class MbrBenefitsLevelVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("会员权益code")
    private String mbrBenefitsCode;

    @ApiModelProperty("会员权益等级code")
    private String mbrBenefitsLevelCode;

    @ApiModelProperty("等级code")
    private String mbrLevelDefCode;

    @ApiModelProperty("等级名称")
    private String levelName;

    @ApiModelProperty("是否开启：1-开启，0-关闭")
    private Boolean status;

    @ApiModelProperty("权益领取方式：1-权益领取，2-链接跳转")
    private Integer claimMethod;

    @ApiModelProperty("权益类型：1-优惠券，2-积分")
    private Integer type;

    @ApiModelProperty("券定义code集合")
    private List<String> couponDefinitionCodeList;

    @ApiModelProperty("积分")
    private Integer integral;

    @ApiModelProperty("获取规则限制类型：1-日，2-周，3-月，4-年")
    private Integer limitType;

    @ApiModelProperty("获取规则限制次数")
    private Integer limitCount;

    @ApiModelProperty("备注")
    private String remark;

}
