package com.bizvane.members.feign.model.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 等级定义表
 * </p>
 *
 * @author Trump
 * @since 2024-10-04
 */
@Data
public class MbrBenefitsDetailVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("会员权益code")
    private String mbrBenefitsCode;

    @ApiModelProperty("权益名称")
    private String name;

    @ApiModelProperty("权益描述")
    private String detail;

    @ApiModelProperty("权益图片URL")
    private String imageUrl;

    @ApiModelProperty("权益说明")
    private String description;

    private String levelNameList;

    private List<MbrBenefitsLevelVO> mbrBenefitsLevelList;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedDate;

}
