package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CouponEntityUseRequestParam {

    @ApiModelProperty("券号")
    @NotBlank
    private String couponNo;

    @ApiModelProperty("使用类型：1-crm系统，2-外部系统")
    private Integer useType;

    @ApiModelProperty("核销人的会员code")
    @NotBlank
    private String useMemberCode;

    @ApiModelProperty("核销机场编号")
    private String useAirportNo;

    @ApiModelProperty("核销业态编号")
    private String useIndustryNo;

    @ApiModelProperty("核销商户编号")
    private String useMerchantNo;

    @ApiModelProperty("券使用订单号")
    private String useBusinessCode;

    @ApiModelProperty("券使用订单金额")
    private BigDecimal useBusinessAmount;

    @ApiModelProperty("使用时间")
    private LocalDateTime useTime;

}
