package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
public class MbrMemberListRequestParam {

    @ApiModelProperty("会员卡号")
    private String cardNo;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("等级code")
    private String mbrLevelDefCode;

    @ApiModelProperty("会员卡状态0：冻结, 1.正常")
    private Integer cardStatus;

    @ApiModelProperty("开卡时间开始")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime openCardTimeStart;

    @ApiModelProperty("开卡时间结束")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime openCardTimeEnd;

    @ApiModelProperty("来源")
    private String sourceCode;

    private int pageNum = 1;

    private int pageSize  = 10;
}
