package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class MbrLevelUpdateRequestBO implements Serializable {

    private static final long serialVersionUID = 1L;

    @NotNull
    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @NotNull
    @ApiModelProperty("等级code")
    private String mbrLevelDefCode;

    @ApiModelProperty("原等级code")
    private String originMbrLevelDefCode;

    @ApiModelProperty("流水条件")
    private String conditions;

    @ApiModelProperty("操作类型：1-升级，2-降级")
    private Integer opsType;

    @ApiModelProperty("变动时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime changeDate;

    @ApiModelProperty("操作人code")
    private String userCode;

    @ApiModelProperty("操作人")
    private String userName;

}
