package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;

@AllArgsConstructor
@NoArgsConstructor
@Data
public class MbrGroupMbrListRequestParam {

    @ApiModelProperty("分组code")
    @NotBlank
    private String mbrGroupDefCode;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    /**
     * 分页查询时，为了避免数据过多造成性能问题，可以设置此参数，只查询大于此id的会员
     */
    @ApiModelProperty("会员大于此id")
    private Long greaterThanMbrId;

    private int pageNum = 1;

    private int pageSize  = 10;
}
