package com.bizvane.members.feign.model.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class MbrFlightRecordBO {

    @ApiModelProperty("会员手机号")
    private String phone;

    @ApiModelProperty("微信unioinId")
    private String unionId;

    @ApiModelProperty("航空公司编号")
    private String airlinesCode;

    @ApiModelProperty("航班号")
    private String flightNo;

    @ApiModelProperty("客票号")
    private String ticketNumber;

    @ApiModelProperty("客票类型：1-成人票，2-儿童票")
    private Integer ticketType;

    @ApiModelProperty("座位号")
    private String seatNumber;

    @ApiModelProperty("出发机场")
    private String departureAirport;

    @ApiModelProperty("到达机场")
    private String arrivalAirport;

    @ApiModelProperty("出发时间")
    private LocalDateTime departureDate;

    @ApiModelProperty("到达时间")
    private LocalDateTime arrivalDate;

    @ApiModelProperty("机票价格")
    private BigDecimal ticketPrice;

    @ApiModelProperty("预定时间")
    private LocalDateTime bookingDate;

    @ApiModelProperty("机型")
    private String aircraftType;

    @ApiModelProperty("行李处理方式：1-未托运，2-已托运")
    private Integer baggageMethods;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("操作人code")
    private String userCode;

    @ApiModelProperty("操作人")
    private String userName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private LocalDateTime createDate;
}
