package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class CouponManualListRequestParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("任务名称")
    private String taskName;

    @ApiModelProperty("券定义名称")
    private String couponDefinitionName;

    @ApiModelProperty("任务状态：5-新建，10-待审核，15-待执行，20-审核不通过，25-发送中，30-发送完成，35-部分失败，40-已作废，45-同步中")
    private Integer taskStatus;

    @ApiModelProperty("券类型：1-批量发券，110预生成券")
    private Integer couponType;

    @ApiModelProperty("券定义code")
    private String couponDefinitionCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建时间开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createDateStart;

    @ApiModelProperty("创建时间结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createDateEnd;

    private int pageNum = 1;

    private int pageSize  = 10;
}
