package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.*;
import com.bizvane.members.feign.model.vo.MbrLevelDefVO;
import com.bizvane.members.feign.model.vo.MbrLevelRecordVO;
import com.bizvane.members.feign.model.vo.MbrStatusVO;
import com.bizvane.members.feign.model.vo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.repository.query.Param;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.constraints.NotNull;
import java.util.List;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/mbrLevel")
@Api("会员等级管理")
public interface MbrLevelFeign {

  @ApiOperation(value = "等级定义列表")
  @RequestMapping(value="/defListAll", method = RequestMethod.POST)
  List<MbrLevelDefVO> defListAll();

  @ApiOperation(value = "等级定义详情")
  @RequestMapping(value="/defDetail", method = RequestMethod.POST)
  MbrLevelDefVO defDetail(@Param("mbrLevelDefCode") @NotNull String mbrLevelDefCode);

  @ApiOperation(value = "等级定义新增")
  @RequestMapping(value="/defAdd", method = RequestMethod.POST)
  ResponseData<String> defAdd(@RequestBody MbrLevelDefAddRequestParam param);

  @ApiOperation(value = "等级定义删除")
  @RequestMapping(value="/defDelete", method = RequestMethod.POST)
  ResponseData<Boolean> defDelete(@Param("mbrLevelDefCode") @NotNull String mbrLabelDefCode);

  @ApiOperation(value = "等级定义修改")
  @RequestMapping(value="/defUpdate", method = RequestMethod.POST)
  ResponseData<Boolean> defUpdate(@RequestBody MbrLevelDefUpdateRequestParam param);

  @ApiOperation(value = "修改会员等级")
  @RequestMapping(value="/updateMbrLevel", method = RequestMethod.POST)
  ResponseData<Boolean> updateMbrLevel(@RequestBody MbrLevelUpdateRequestParam param);

  @ApiOperation(value = "等级变更记录新增")
  @RequestMapping(value="/recordAdd", method = RequestMethod.POST)
  ResponseData<Boolean> recordAdd(@RequestBody MbrLevelRecordAddRequestParam param);

  @ApiOperation(value = "等级变更记录列表")
  @RequestMapping(value="/recordList", method = RequestMethod.POST)
  PageInfo<MbrLevelRecordVO> recordList(@RequestBody MbrLevelRecordListRequestParam param);

}
