package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.*;
import com.bizvane.members.feign.model.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.repository.query.Param;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.constraints.NotNull;
import java.util.List;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/mbrBenefits")
@Api("会员权益管理")
public interface MbrBenefitsFeign {

  @ApiOperation(value = "权益列表")
  @RequestMapping(value="/list", method = RequestMethod.POST)
  PageInfo<MbrBenefitsVO> list(MbrBenefitsListRequestParam param);

  @ApiOperation(value = "权益详情")
  @RequestMapping(value="/detail", method = RequestMethod.POST)
  MbrBenefitsVO detail(@Param("mbrBenefitsCode") @NotNull String mbrBenefitsCode);

  @ApiOperation(value = "等级定义新增")
  @RequestMapping(value="/add", method = RequestMethod.POST)
  ResponseData<String> add(@RequestBody MbrBenefitsAddRequestParam param);

  @ApiOperation(value = "等级定义删除")
  @RequestMapping(value="/delete", method = RequestMethod.POST)
  ResponseData<Boolean> delete(@Param("mbrBenefitsCode") @NotNull String mbrBenefitsCode);

  @ApiOperation(value = "等级定义修改")
  @RequestMapping(value="/update", method = RequestMethod.POST)
  ResponseData<Boolean> update(@RequestBody MbrBenefitsUpdateRequestParam param);

}
