package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.MbrIntegralAddRequestParam;
import com.bizvane.members.feign.model.bo.MbrIntegralRecordListRequestParam;
import com.bizvane.members.feign.model.bo.MbrIntegralSubRequestParam;
import com.bizvane.members.feign.model.vo.MbrIntegralRecordVO;
import com.bizvane.members.feign.model.vo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/integral")
@Api("积分管理")
public interface IntegralFeign {

    @ApiOperation(value = "增加积分")
    @RequestMapping(value="/add", method = RequestMethod.POST)
    ResponseData<String> add(@RequestBody MbrIntegralAddRequestParam param);

    @ApiOperation(value = "扣减积分")
    @RequestMapping(value="/sub", method = RequestMethod.POST)
    ResponseData<String> sub(@RequestBody MbrIntegralSubRequestParam param);

    @ApiOperation(value = "查询积分流水")
    @RequestMapping(value="/recordlist", method = RequestMethod.POST)
    ResponseData<PageInfo<MbrIntegralRecordVO>> recordlist(@RequestBody MbrIntegralRecordListRequestParam param);
}
