package com.bizvane.members.feign.service;

import com.bizvane.members.feign.model.bo.MbrStatusAddRequestParam;
import com.bizvane.members.feign.model.bo.MbrStatusListRequestParam;
import com.bizvane.members.feign.model.vo.MbrStatusVO;
import com.bizvane.members.feign.model.vo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.repository.query.Param;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value="${feign.client.members.name}",path="${feign.client.members.path}/coupon")
@Api("券管理")
public interface CouponFeign {

  @ApiOperation(value = "发券")
  @RequestMapping(value="/coupon", method = RequestMethod.POST)
  ResponseData<Boolean> end(@RequestBody MbrStatusAddRequestParam param);

}
