package com.bizvane.members.feign.model.bo;

import com.bizvane.utils.enumutils.ChannelEnum;
import com.bizvane.utils.enumutils.SourceEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class CouponEntityAddRequestParam {

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @NotNull
    @ApiModelProperty("发放类型：枚举类CouponSendTypeEnum，字典coupon_send_type")
    private Integer sendType;

    @ApiModelProperty("发放渠道code")
    private String sendChannelCode = ChannelEnum.WECHAT.getType();

    @ApiModelProperty("发放来源code")
    private String sendSourceCode = SourceEnum.LOVE.getType();

    @NotEmpty
    @ApiModelProperty("券定义code列表")
    private List<CouponEntityAddDetailRequestParam> couponDefinitionList;

    @ApiModelProperty("创建人code")
    private String userCode;

    @ApiModelProperty("创建人")
    private String userName;

    @ApiModelProperty("发券商户")
    private String sendMerchantCode;

    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    @Data
    public static class CouponEntityAddDetailRequestParam {

        @ApiModelProperty("券定义code")
        @NotEmpty
        private String couponDefinitionCode;

        @ApiModelProperty("发券业务描述")
        private String sendBusinessName;

        @ApiModelProperty("发券业务单号")
        @NotEmpty
        private String sendBusinessCode;

        @ApiModelProperty("发券二级业务单号")
        private String sendBusinessCode2;

        @ApiModelProperty("发券三级业务单号")
        private String sendBusinessCode3;
    }

}
