package com.bizvane.members.feign.model.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Data
public class MbrAddressUpdateRequestParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("会员地址code")
    @NotBlank
    private String mbrAddressCode;

    @ApiModelProperty("会员code")
    @NotBlank
    private String mbrMembersCode;

    @ApiModelProperty("收货人")
    @NotBlank
    private String name;

    @ApiModelProperty("联系电话脱敏")
    @NotBlank
    private String phone;

    @ApiModelProperty("联系电话加密")
    @NotBlank
    private String phoneEncrypt;

    @ApiModelProperty("省")
    @NotBlank
    private String province;

    @ApiModelProperty("市")
    @NotBlank
    private String city;

    @ApiModelProperty("区")
    @NotBlank
    private String county;

    @ApiModelProperty("详细地址")
    @NotBlank
    private String address;

    @ApiModelProperty("是否默认地址：true-默认，false-非默认")
    private Boolean defaultAddress;

    @ApiModelProperty("操作人code")
    private String userCode;

    @ApiModelProperty("操作人")
    private String userName;
}
