package com.bizvane.members.facade.enums.alipay.electcard;

/**
 * <h3>支付宝会员卡开卡表单模板配置bo-会员卡开卡时的表单字段配置信息枚举</h3>
 * @author 刘莹
 */
public enum AlipayElectCardFormTemplateOpenFormFieldEnum {

    OPEN_FORM_FIELD_MOBILE("OPEN_FORM_FIELD_MOBILE","手机号"),
    OPEN_FORM_FIELD_GENDER ("OPEN_FORM_FIELD_GENDER","性别"),
    OPEN_FORM_FIELD_NAME ("OPEN_FORM_FIELD_NAME","姓名"),
    OPEN_FORM_FIELD_BIRTHDAY ("OPEN_FORM_FIELD_BIRTHDAY","生日"),
    OPEN_FORM_FIELD_IDCARD ("OPEN_FORM_FIELD_IDCARD","身份证"),
    OPEN_FORM_FIELD_EMAIL ("OPEN_FORM_FIELD_EMAIL","邮箱"),
    OPEN_FORM_FIELD_ADDRESS ("OPEN_FORM_FIELD_ADDRESS","地址"),
    OPEN_FORM_FIELD_CITY ("OPEN_FORM_FIELD_CITY","城市"),
    OPEN_FORM_FIELD_ADDRESS_PROV("OPEN_FORM_FIELD_ADDRESS_PROV","省份"),
    OPEN_FORM_FIELD_ADDRESS_CITY("OPEN_FORM_FIELD_ADDRESS_CITY","市"),
    OPEN_FORM_FIELD_ADDRESS_AREA("OPEN_FORM_FIELD_ADDRESS_AREA","区"),
    OPEN_FORM_FIELD_IS_STUDENT ("OPEN_FORM_FIELD_IS_STUDENT","是否学生认证"),
    OPEN_FORM_FIELD_MEMBER_GRADE ("OPEN_FORM_FIELD_MEMBER_GRADE","会员等级"),
    /**
     * 0 -- 身份证
     * 1 -- 护照
     * 2 -- 港澳居民通行证
     * 3 -- 台湾居民通行证
     */
    OPEN_FORM_FIELD_CERT_TYPE("OPEN_FORM_FIELD_CERT_TYPE","证件类型字段");

    private String code;

    private String name;

    AlipayElectCardFormTemplateOpenFormFieldEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static String getCodeByName(String name) {
        for (AlipayElectCardFormTemplateOpenFormFieldEnum formTemplateOpenFormFieldEnum : AlipayElectCardFormTemplateOpenFormFieldEnum.values()) {
            if (formTemplateOpenFormFieldEnum.getName().equals(name)) {
                return formTemplateOpenFormFieldEnum.getCode();
            }
        }
        return null;
    }
}
