package com.bizvane.members.facade.models;

import com.bizvane.members.facade.utils.EncryptPhone;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 会员信息model
 * <p>
 * 内部使用
 */
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
@Builder
@AllArgsConstructor
@EncryptPhone
@Table(name = "t_mbr_members")
public class MemberInfoModel extends BaseModel implements Serializable {

    private static final long serialVersionUID = -7718431512626549518L;

    @ApiModelProperty(value = "会员id", name = "mbrMemberId")
    @Id
    private Long mbrMemberId;

    @Transient
    private String offlineOrgCode;

    @ApiModelProperty(value = "会员code", name = "memberCode")
    private String memberCode;

    @ApiModelProperty(value = "会员线上卡号", name = "cardNo")
    private String cardNo;

    @ApiModelProperty(value = "会员线下卡号", name = "offlineCardNo")
    private String offlineCardNo;

    @ApiModelProperty(value = "会员姓名", name = "name")
    private String name;

    @ApiModelProperty(value = "会员手机号", name = "phone")
    @EncryptPhone
    private String phone;

    @ApiModelProperty(value = "会员身份证号", name = "idCard")
    private String idCard;

    @ApiModelProperty(value = "会员性别", name = "gender")
    private String gender;

    @ApiModelProperty(value = "会员生日", name = "birthday")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "Asia/Shanghai")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date birthday;

    @ApiModelProperty(value = "冗余生日时间格式，月日", name = "birthdayMd")
    private String birthdayMd;

    @ApiModelProperty(value = "会员省份", name = "province")
    private String province;

    @ApiModelProperty(value = "会员城市", name = "city")
    private String city;

    @ApiModelProperty(value = "会员区县", name = "county")
    private String county;

    @ApiModelProperty(value = "会员详细地址", name = "address")
    private String address;

    @ApiModelProperty(value = "会员邮件", name = "email")
    private String email;

    @ApiModelProperty(value = "会员头像", name = "headPortraits")
    private String headPortraits;

    @ApiModelProperty(value = "会员卡条形码", name = "barCode")
    private String barCode;

    @ApiModelProperty(value = "会员体系id", name = "memberSysId")
    private Long memberSysId;

    @ApiModelProperty(value = "企业id", name = "sysCompanyId")
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌id", name = "brandId")
    private Long brandId;

    @ApiModelProperty(value = "erpId", name = "erpId")
    private String erpId;

    @ApiModelProperty(value = "开卡时间", name = "openCardTime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date openCardTime;

    @ApiModelProperty(value = "绑卡时间", name = "bindCardTime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date bindCardTime;

    @ApiModelProperty(value = "有效期", name = "effectiveTime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date effectiveTime;

    @ApiModelProperty(value = "开卡渠道id", name = "openCardChannelId")
    private Long openCardChannelId;

    @ApiModelProperty(value = "全渠道会员卡ids", name = "allChannelIds")
    private String allChannelIds;

    @ApiModelProperty(value = "推广渠道", name = "generalizeChannel")
    private String generalizeChannel;

    @ApiModelProperty(value = "开卡导购id", name = "openCardGuideId")
    private Long openCardGuideId;

    @ApiModelProperty(value = "线下归属经销商id", name = "offlineDealerAttributionId")
    private Long offlineDealerAttributionId;

    @ApiModelProperty(value = "开卡门店id", name = "openCardStoreId")
    private Long openCardStoreId;

    @ApiModelProperty(value = "服务门店id", name = "serviceStoreId")
    private Long serviceStoreId;

    @ApiModelProperty(value = "服务导购id", name = "serviceGuideId")
    private Long serviceGuideId;

    @ApiModelProperty(value = "服务导购name", name = "serviceGuideName")
    private String serviceGuideName;

    @ApiModelProperty(value = "活跃门店", name = "activeStore")
    private String activeStore;

    @ApiModelProperty(value = "微信openId", name = "wxOpenId")
    private String wxOpenId;

    @ApiModelProperty(value = "微信UnionId", name = "wxUnionId")
    private String wxUnionId;

    @ApiModelProperty(value = "微信公众号Id", name = "wxPublicId")
    private Long wxPublicId;

    @ApiModelProperty(value = "会员等级Id", name = "levelId")
    private Long levelId;

    @ApiModelProperty(value = "会员等级名称", name = "levelName")
    private String levelName;

    @Transient
    @ApiModelProperty(value = "会员等级code", name = "levelCode")
    private String levelCode;

    @ApiModelProperty(value = "会员标签names", name = "labelNames")
    private String labelNames;

    @ApiModelProperty(value = "会员标签Ids", name = "labelIds")
    private String labelIds;

    @ApiModelProperty(value = "自定义会员标签names", name = "customLabelNames")
    private String customLabelNames;

    @ApiModelProperty(value = "自定义会员标签Ids", name = "customLabelIds")
    private String customLabelIds;

    @ApiModelProperty(value = "扩展属性Ids", name = "extendIds")
    private String extendIds;

    @ApiModelProperty(value = "累计可用积分", name = "countIntegral")
    private Integer countIntegral;

    @ApiModelProperty(value = "分销状态", name = "distributionState")
    private Integer distributionState;


    @ApiModelProperty(value = "分销创建人", name = "distributionCreateName")
    private String distributionCreateName;

    @ApiModelProperty(value = "分销会员创建时间", name = "distributionCreateTime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date distributionCreateTime;

    @ApiModelProperty(value = "分销状态修改人", name = "distributionModifiedName")
    private String distributionModifiedName;

    @ApiModelProperty(value = "分销状态修改时间", name = "distributionModifiedTime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date distributionModifiedTime;

    @ApiModelProperty(name = "cardStatus", value = "微信绑卡状态：1绑卡、2未帮卡")
    private Integer cardStatus;

    @ApiModelProperty(name = "firstLandingCheck", value = "是否首次登录")
    private Integer firstLandingCheck;

    @ApiModelProperty(name = "dataIntegrityPercentage", value = "数据完整性占比（0-100）")
    private Integer dataIntegrityPercentage;

    @ApiModelProperty(value = "线下品牌code", name = "offlineBrandCode", required = false, example = "线下品牌code")
    private String offlineBrandCode;

    @ApiModelProperty(value = "开卡导购线下code", name = "openCardGuideCode", required = false, example = "开卡导购线下code")
    private String openCardGuideCode;

    @ApiModelProperty(value = "开卡导购名称(个别场景有值)", name = "openCardGuideName")
    private String openCardGuideName;

    @ApiModelProperty(value = "线下经销商", name = "offlineDealerAttributionCode", required = false, example = "线下经销商")
    private String offlineDealerAttributionCode;

    @ApiModelProperty(value = "线下归属经销商name", name = "dealerAttributionName", required = false, example = "线下归属经销商name")
    private String dealerAttributionName;

    @ApiModelProperty(value = "开卡店铺线下code", name = "openCardStoreCode", required = false, example = "开卡店铺线下code")
    private String openCardStoreCode;

    @ApiModelProperty(value = "开卡店铺线名称(个别场景有值)", name = "openCardStoreName")
    private String openCardStoreName;

    @ApiModelProperty(value = "服务门店线下code", name = "serviceStoreCode", required = false, example = "服务门店线下code")
    private String serviceStoreCode;

    @ApiModelProperty(value = "服务导购线下code", name = "serviceGuideCode", required = false, example = "服务导购线下code")
    private String serviceGuideCode;

    @ApiModelProperty(value = "线下等级code", name = "offlineLevelCode", required = false, example = "线下等级code")
    private String offlineLevelCode;

    @ApiModelProperty(value = "累计收入的总积分", name = "addUpIntegral", example = "累计收入的总积分")
    private Integer addUpIntegral;

    @ApiModelProperty(value = "即将到期积分", name = "aboutExpireIntegral", example = "即将到期积分")
    private Integer aboutExpireIntegral;

    @ApiModelProperty(value = "即将到期时间", name = "aboutExpireTime", example = "即将到期时间")
    private Date aboutExpireTime;

    @ApiModelProperty(value = "线下更新时间", name = "offlineUpdateDate", example = "线下更新时间")
    private Date offlineUpdateDate;

    @ApiModelProperty(value = "已过期积分", name = "pastDueIntegral", example = "已过期积分")
    private Integer pastDueIntegral;

    @ApiModelProperty(value = "已消耗积分", name = "consumeIntegral", example = "已消耗积分")
    private Integer consumeIntegral;

    @ApiModelProperty(value = "冻结积分", name = "consumeIntegral", example = "冻结积分")
    private Integer freezeIntegral;

    @ApiModelProperty(value = "积分兑换券次数", name = "consumeIntegral", example = "冻结积分")
    private Integer integralExchangeTicketCount;

    @ApiModelProperty(value = "线下企业code", name = "companyCode", example = "线下企业code")
    private String offlineCompanyCode;

    @ApiModelProperty(value = "省份code", name = "provinceCode", example = "省份code")
    private String provinceCode;

    @ApiModelProperty(value = "市code", name = "cityCode", example = "市code")
    private String cityCode;

    @ApiModelProperty(value = "区code", name = "consumeIntegral", example = "已消耗积分")
    private String countyCode;


    @ApiModelProperty(value = "折扣计算方式: 0=就低原则;1=折上折原则", name = "discountMethod")
    private Integer discountMethod;

    @ApiModelProperty(value = "会员折扣", name = "memberDiscount")
    private Integer memberDiscount;

    @ApiModelProperty(value = "折上折", name = "additionalDiscount")
    private Integer additionalDiscount;

    @ApiModelProperty(value = "积分计算规则:1=向上取整;2=四舍五入;3=向下取整", name = "calculateRule")
    private Integer calculateRule;

    @ApiModelProperty(value = "最后一次ES更新数据的时间", name = "lastEsTime")
    private Date lastEsTime;

    @ApiModelProperty(value = "会员来源分配人", name = "membersFrom")
    private String membersFrom;
    @ApiModelProperty(value = "会员来源时间")
    private Date dateFrom;
    @ApiModelProperty(value = "会员标注", name = "mark")
    private Integer mark;
    @ApiModelProperty(value = "是否企业好友", name = "companyFriend")
    private Integer companyFriend;
    @ApiModelProperty(value = "会员导购好友集合，以-隔开", name = "companyGuideFriends")
    private String companyGuideFriends;
    @ApiModelProperty(value = "会员备注", name = "memberComment")
    private String memberComment;
    @ApiModelProperty(value = "好友userid", name = "externalUserId")
    private String externalUserId;

    @ApiModelProperty(value = "线下积分更新时间", name = "offlineUpdateIntegralDate", example = "线下积分更新时间")
    private Date offlineUpdateIntegralDate;

    
    @ApiModelProperty(value="微信推广渠道",name="wxGeneralizeChannel",example="微信推广渠道")
    private String wxGeneralizeChannel;
    
    @ApiModelProperty(name="activetyId",value="活动id，表示会员通过活动开卡")
    private Long activityId;
    
    @ApiModelProperty(name="activityType",value="活动类型")
    private Integer activityType;
    
    private java.sql.Date birthday1;
    
    @ApiModelProperty(name="openCardScene",value="开卡场景 1扫码开卡 2绑卡 3 自选开卡门店 4默认开卡门店")
    private Integer openCardScene;
    
    @ApiModelProperty(name="channel",value="二维码渠道")
    private Integer channel;
    
    @ApiModelProperty(name="balance",value="充值余额")
    private BigDecimal balance;
    
    @ApiModelProperty(name="levelUpTime",value="升级时间")
    private Date levelUpTime;

    @ApiModelProperty(name = "babyBirthday ",value = "宝宝生日")
    private Date babyBirthday;

    @ApiModelProperty(name = "babyBirthdayMd",value = "宝宝生日MMdd格式")
    private String babyBirthdayMd;

    @ApiModelProperty(name = "firstOrderTime",value = "会员首单时间")
    private Date firstOrderTime;

    private String petCard;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date offlineUpdateBalanceDate;

    @ApiModelProperty(name = "registerType",value = "注册类型")
    private Integer registerType;

    @ApiModelProperty(value = "邮箱验证状态 1未验证 2已验证 3无", name = "emailStatus")
    private Integer emailStatus;

    @ApiModelProperty(name = "cardUseStatus",value = "会员卡状态")
    private Integer cardUseStatus;

    private BigDecimal consumeAmountAll;//累计消费金额

    private Integer consumeNumberAll;//累计消费次数

    private Integer refundNumberAll;//退货次数

    private BigDecimal pctAmountAll;//客单价

    @ApiModelProperty(name = "areaCode",value = "手机号区号")
    private String areaCode;

    /***/
    /**
     * 默认开卡门店
     * */
    private Long defaultOpenStoreId;
    private String defaultOpenStoreCode;

    /**
     * 默认开卡导购
     */
    private Long defaultOpenGuideId;
    private String defaultOpenGuideCode;

    //标签表主键
    private Long mbrConsumeBehaviorId;

    /**
     * 即将过期积分
     */
    @Transient
    private Integer expiringIntegral;
    /**
     * 即将过期积分时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date expiringIntegralTime;

    @ApiModelProperty(name = "memberElectCardCode", value = "会员电子电子会员卡Code")
    private String memberElectCardCode;

    @Transient
    @ApiModelProperty(name = "newExtendProperty", value = "自定义属性（新的自定义属性：年龄带）")
    private String newExtendProperty;


    @ApiModelProperty(name = "recommendMemberCode", value = "推荐人的会员code")
    private String recommendMemberCode;

    private BigDecimal consumeAmount3;

    private BigDecimal consumeAmount6;

    private BigDecimal consumeAmount9;

    private BigDecimal consumeAmount12;

    private BigDecimal consumeAmount24;

    private Integer shopStatus;

    /**
     * 运营组织Code
     */
    @Transient
    private String organizationCode;


    /**
     * 首次工作日期
     */
    private String firstWorkDate;

    /**
     * 施工能力id
     */
    private String constructabilityIds;

    /**
     * 证件照
     */
    private String certPhoto;

}
