package com.bizvane.members.facade.models.po;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 会员积分使用记录
 * </p>
 *
 * @author Trump
 * @since 2025-04-14
 */
@Getter
@Setter
@TableName("t_mbr_integral_record")
@ApiModel(value = "TMbrIntegralRecordPO对象", description = "会员积分使用记录")
public class TMbrIntegralRecordPO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键id")
    @TableId(value = "mbr_integral_record_id", type = IdType.AUTO)
    private Long mbrIntegralRecordId;

    @ApiModelProperty("企业id")
    private Long sysCompanyId;

    @ApiModelProperty("品牌id")
    private Long brandId;

    @ApiModelProperty("渠道code")
    private String channelCode;

    @ApiModelProperty("事业部code")
    private String offlineOrgCode;

    @ApiModelProperty("流水code")
    private String recordCode;

    @ApiModelProperty("会员code")
    private String memberCode;

    @ApiModelProperty("变更单据")
    private String changeBills;

    @ApiModelProperty("变更积分")
    private Integer changeIntegral;

    @ApiModelProperty("可用积分")
    private Integer availableIntegral;

    @ApiModelProperty("已使用的积分")
    private Integer usedIntegral;

    @ApiModelProperty("过期的积分")
    private Integer expiredIntegral;

    @ApiModelProperty("变动时间")
    private LocalDateTime changeDate;

    @ApiModelProperty("变动类型1.支出,2.收入,3过期")
    private String changeWay;

    @ApiModelProperty("变更详情")
    private String changeDetails;

    @ApiModelProperty("1积分过期，2保留原积分，3积分清零，4手动调整支出，5手动调整获取，6商品消费获取，7积分兑换支出，8游戏消耗支出，9开卡活动，10智能营销活动，11升级活动，12扫码领券活动，13手动领券活动，14消费活动，15签到活动，16生日活动，17完善资料任务，18微信分享任务，19消费金额任务，20消费次数任务，21邀请开卡任务，22纪念日活动，23评价奖励活动，24线下手动调整，25线下活动调整，26积分兑换券，27转盘活动，28红包膨胀活动，29砸金蛋活动，30积分商城消费积分，31积分商城返还积分，32首单开卡活动，33宝宝生日活动，34兑换有赞积分，35微商城积分扣减，36微商城积分返还，-1积分补偿，37摇一摇，38储值送礼，39佣金兑换，40天猫消费积分，42调查问卷任务，100赠送，101消费，102退货，103积分调整减积分，104积分调整增积分，105积分兑换，106积分抵现，107积分抵现返还，108积分清零，109赠送退回，110其它")
    private String businessWay;

    @ApiModelProperty("线下业务类型")
    private String businessWayOffline;

    @ApiModelProperty("积分有效时间")
    private LocalDateTime effectiveTime;

    @ApiModelProperty("会员名称")
    private String memberName;

    @ApiModelProperty("会员卡号")
    private String memberCardNo;

    @ApiModelProperty("数据有效性：1=有效；0=无效")
    private Byte valid;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人id")
    private Long createUserId;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    private LocalDateTime createDate;

    @ApiModelProperty("修改人id")
    private Long modifiedUserId;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedDate;

    @ApiModelProperty("版本号")
    private Integer version;

    @ApiModelProperty("线下品牌code")
    private String offlineBrandCode;

    @ApiModelProperty("线下积分id")
    private String offlineIntegralId;

    @ApiModelProperty("线下企业code")
    private String offlineCompanyCode;

    @ApiModelProperty("线下会员id")
    private String erpId;

    @ApiModelProperty("UR积分数额")
    private Integer pointsAmount;

    @ApiModelProperty("UR门店ID")
    private String storeId;

    @ApiModelProperty("UR积分来源")
    private String source;

    @ApiModelProperty("业务类型描述，关联积分流水业务类型字典表描述")
    private String businessDescription;

    @ApiModelProperty("线上门店code")
    private String onlineStoreCode;

    @ApiModelProperty("361线下门店code")
    private String offlineStoreCode;

    @ApiModelProperty("同步ElasticSearch最后修改时间")
    private LocalDateTime lastEsTime;
}
