package com.bizvane.members.facade.vo.yanzhiwu;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class MemberOpenCardRequestVo {

    private String source;

    @NotBlank
    private String brandCode;//	是	string	品牌

    @NotBlank
    private String offlineOrgCode;

    @NotBlank
    private String externalId;

    @NotBlank
    private String phone;//	是	string	手机号

    @NotNull
    private Integer type;

    @NotNull
    private String channelCode;// source	是	int	会员注册渠道 : 1.POS(门店) 2.官网3.商城 4.微信 5.天猫 6.其他

    @NotBlank
    private String sourceCode;

    private Long sysCompanyId;//公司id

    private String offlineCompanyCode;


    private String cardNo;//	是	string	会员卡号
    private String name;    //否	string	会员名称
    private Integer sex;    //否	int	性别 : 1.女 2.男 3.未知
    private String province;//	否	string	省
    private String city;//	否	string	市
    private String county;//	否	string	区
    private String address;//	否	string	会员详细地址
    private String remark;//	否	string	备注
    private String email;//	否	string	会员邮箱
    private String idCard;//	否	string	会员身份证号
    private String birthday;//	否	string	会员生日 格式 : yyyy-mm-dd
    private String storeCode;//	否	string	注册门店code,如果为空则默认按照中台配置的会员卡体系为准
    private String levelCode;//	否	string	会员等级code,如果为空则默认按照中台配置的会员卡体系为准

    //guideCode
    private String guideCode;//否 string 导购code,如果为空则默认按照中台配置的会员卡体系为准

    private Integer points;//	否	int	会员可用积分,如果为空则默认为0

    private Date openCardTime;

    /**
     * 服务导购
     * */
    private String serviceGuideCode;

    /**
     * 服务导购电话
     * */
    @ApiModelProperty(value = "服务导购电话", name = "serviceGuidePhone",notes="根据电话查询导购信息")
    private String serviceGuidePhone;

    /**
     * 服务门店
     * */
    private String serviceStoreCode;

    /**
     * 邀请人会员手机号
     */
    private String inviterPhone;

    /**
     * 自定义属性json串 {"extendOfflineCode1":"value1","extendOfflineCode2":"value2"}
     */
    private String extendProperty;

}
