package com.bizvane.members.facade.dto;

import com.bizvane.members.facade.utils.EncryptCardNo;
import com.bizvane.members.facade.utils.EncryptPhone;
import lombok.Data;

import java.util.Date;

/**
 * @Author: lijunwei
 * @Time: 2019/3/22 15:41
 */
@Data
@EncryptPhone
@EncryptCardNo
public class MbrLevelRecordDto {
    private Long mbrLevelTraceId;
    private String memberCode;
    @EncryptCardNo
    private String cardNo;
    @EncryptCardNo
    private String name;
    @EncryptPhone
    private String phone;
    private Long originLevelId;
    private String originLevelName;
    private Long currentLevelId;
    private String currentLevelName;
    private Integer resultFlag;
    private String reason;
    private Date createDate;
    private Integer opsType;
    private String erpId;
    private String currentLevelCode;
    private String originLevelCode;
    private Date modifiedDate;

    /**
     * 变更类型，1升级 2降级
     */
    private Integer changeType;

    /**
     * 操作类型，1系统调整，2手动调整
     */
    private Integer operationType;

}
