package com.bizvane.members.facade.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.members.facade.models.IntegralRecordModel;
import com.bizvane.members.facade.models.MbrGroupModel;
import com.bizvane.members.facade.vo.ConsumeRecordVo;
import com.bizvane.members.facade.vo.MemberInfoCardVo;
import com.bizvane.members.facade.vo.MemberInfoVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 会员信息脱敏工具
 * @author huangxinliu
 * @date: 2021/1/25 13:46
 */
@Slf4j
public class MemberDesensitizeUtil {


    /**
     * 数据脱敏-会员信息
     * @param memberInfoVo
     */
    public static void encryptMemberInfoVo(MemberInfoVo memberInfoVo){
        if(Objects.nonNull(memberInfoVo)){
            memberInfoVo.setCardNo(DesensitizeUtil.encrypt(memberInfoVo.getCardNo()));
            memberInfoVo.setOfflineCardNo(DesensitizeUtil.encrypt(memberInfoVo.getOfflineCardNo()));
            memberInfoVo.setPhone(DesensitizeUtil.encrypt(memberInfoVo.getPhone()));
            memberInfoVo.setErpId(DesensitizeUtil.encrypt(memberInfoVo.getErpId()));
        }
    }

    /**
     * 数据脱敏-会员消费统计信息
     * @param consumeRecordVo
     */
    public static void encryptConsumeRecordVo(ConsumeRecordVo consumeRecordVo){
        if(Objects.nonNull(consumeRecordVo)){
            consumeRecordVo.setCardNo(DesensitizeUtil.encrypt(consumeRecordVo.getCardNo()));
        }
    }

    /**
     * 数据脱敏-会员卡信息
     * @param memberInfoCardVo
     */
    public static void encryptMemberInfoCardVo(MemberInfoCardVo memberInfoCardVo){
        if(Objects.nonNull(memberInfoCardVo)){
            memberInfoCardVo.setCardNo(DesensitizeUtil.encrypt(memberInfoCardVo.getCardNo()));
            memberInfoCardVo.setErpid(DesensitizeUtil.encrypt(memberInfoCardVo.getErpid()));
        }
    }


    /**
     * 数据脱敏-积分流水
     * @param integralRecordModel
     */
    public static void encryptIntegralRecordModel(IntegralRecordModel integralRecordModel){
        if(Objects.nonNull(integralRecordModel)){
            integralRecordModel.setCardNo(DesensitizeUtil.encrypt(integralRecordModel.getCardNo()));
            integralRecordModel.setMemberCardNo(DesensitizeUtil.encrypt(integralRecordModel.getMemberCardNo()));
            integralRecordModel.setMemberPhone(DesensitizeUtil.encrypt(integralRecordModel.getMemberPhone()));
            integralRecordModel.setErpId(DesensitizeUtil.encrypt(integralRecordModel.getErpId()));
        }
    }

    /**
     * 数据脱敏-会员分组
     * @param mbrGroupModel
     */
    public static void encryptMemberInfoVo(MbrGroupModel mbrGroupModel){
        if(Objects.nonNull(mbrGroupModel)){
            if(StringUtils.isNotBlank(mbrGroupModel.getConditions())){
                try {
                    JSONObject mbrGroupModelObj = JSON.parseObject(mbrGroupModel.getConditions());
                    if(Objects.nonNull(mbrGroupModelObj)){
                        JSONObject phoneBatchObj = mbrGroupModelObj.getJSONObject("phoneBatch");
                        if(Objects.nonNull(phoneBatchObj)){
                            String mobileStr = phoneBatchObj.getString("mobile");
                            if(StringUtils.isNotBlank(mobileStr)){
                                String[] mobileArr = mobileStr.split(",");
                                List<String> mobileDesensitizeList = new ArrayList<>(mobileArr.length);
                                for (int i = 0; i < mobileArr.length; i++) {
                                    String mobile = mobileArr[i];
                                    String mobileDesensitize =  DesensitizeUtil.encrypt(mobile);
                                    mobileDesensitizeList.add(mobileDesensitize);
                                }
                                String mobileDesensitizeStr = StringUtils.join(mobileDesensitizeList);
                                phoneBatchObj.put("mobile", mobileDesensitizeStr);
                                mbrGroupModel.setConditions(JSON.toJSONString(mbrGroupModelObj));
                            }
                        }
                    }
                }catch (Exception e){
                    log.error("JSON.parseObject error", e);
                }
            }
        }
    }

}
