package com.bizvane.members.facade.service.api361;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.vo.OpenApiBindCardRequestVo;
import com.bizvane.members.facade.vo.OpenApiBindCardResponseVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface WeiMobChannelBindCardService {

    @RequestMapping(value = "/api/weimob/bindCard", method = RequestMethod.POST)
    ResponseData<OpenApiBindCardResponseVo> bindCard(@RequestBody @Valid OpenApiBindCardRequestVo openApiBindCardRequestVo) throws MemberException;
}
