package com.bizvane.members.facade.service.card.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * <p>
 * 361积分调整接口请求参数model
 * </p>
 * @author dingShiChen
 * @since 2019/10/17
 */
@Data
@AllArgsConstructor
@Builder
@NoArgsConstructor
public class IntegralChange361ApiRequestModel {

	@ApiModelProperty(name = "offlineBrandCode", value = "线下品牌code")
	private String offlineBrandCode;

	@ApiModelProperty(name = "erpid", value = "线下系统会员id")
	private String erpid;

	@ApiModelProperty(name = "integral", value = "正负值的调整积分数量")
	private String integral;

	@ApiModelProperty(name = "sysCompanyId", value = "公司id")
	private Long sysCompanyId;

	@ApiModelProperty(name = "brandId", value = "品牌Id")
	private Long brandId;

	@ApiModelProperty(name = "memberCode", value = "会员code")
	private String memberCode;

	@ApiModelProperty(name = "changeBills", value = "变更单据")
	private String changeBills;

	@ApiModelProperty(name = "cardNo", value = "会员卡号")
	private String cardNo;

	@ApiModelProperty(name = "offlineCardNo", value = "线下会员卡号")
	private String offlineCardNo;

	@ApiModelProperty(name = "changeIntegral", value = "调整积分数量")
	private Integer changeIntegral;

	@ApiModelProperty(value = "变更时间", name = "changeDate", example = "变更时间")
	private String changeDate;

	@ApiModelProperty(name = "changeType", value = "调整类型")
	private String changeType;

	@ApiModelProperty(name = "businessType", value = "业务类型")
	private String businessType;

	@ApiModelProperty(name = "changeDetails", value = "积分调整详情")
	private String changeDetails;

	@ApiModelProperty(name = "operateUserId", value = "操作人id")
	private Long operateUserId;

	@ApiModelProperty(name = "operateUserName", value = "操作人姓名")
	private String operateUserName;

	@ApiModelProperty(name = "pointsAmount", value = "积分数额")
	private Integer pointsAmount;

	@ApiModelProperty(name = "storeId", value = "门店id")
	private String storeId;

	@ApiModelProperty(name = "source", value = "积分来源")
	private String source;

	private String storeCode;

	@ApiModelProperty(name = "allowNegativeIntegral", value = "允许负数积分,true允许,false不允许")
	private Boolean allowNegativeIntegral;
}
