package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.service.card.request.IntegralChangeForTmallReqVo;
import com.bizvane.members.facade.service.card.request.IntegralChangeRequestModel;
import com.bizvane.members.facade.service.card.response.IntegralChangeResponseModel;
import com.bizvane.members.facade.vo.SyncIntegralVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public interface IntegralChangeInnerService {


    /**
     * 积分变动操作
     *
     * @param integralChangeRequestModel
     * @return
     */
    @RequestMapping(value = "/api/integralChangeOperate", method = RequestMethod.POST)
    public IntegralChangeResponseModel integralChangeOperate(@RequestBody IntegralChangeRequestModel integralChangeRequestModel);

    /**
     * 积分变动操作
     *
     * @param vo
     * @return
     */
    @RequestMapping(value = "/api/integralChangeOperateForTmall", method = RequestMethod.POST)
    public IntegralChangeResponseModel integralChangeOperateForTmall(@RequestBody IntegralChangeForTmallReqVo vo);

    /**
     * 线下积分流水同步到线上
     *
     * @param vo
     * @return
     */
    @RequestMapping(value = "/api/offlineSyncIntegral", method = RequestMethod.POST)
    ResponseData offlineSyncIntegral(@RequestBody SyncIntegralVo vo);

    /**
     * 补数据使用
     *
     * @param syncIntegralVo
     * @return
     */
    @RequestMapping(value = "/api/offlineSyncIntegralConsume", method = RequestMethod.POST)
    ResponseData offlineSyncIntegralConsume(@RequestBody SyncIntegralVo syncIntegralVo);

}
