package com.bizvane.members.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author: houkai
 * @Date: 2018/7/24 16:13
 * @Description:订单评价详情
 */
@Data
public class OrderRateModel implements Serializable {

    private static final long serialVersionUID = -8971300126268762784L;

    @ApiModelProperty(value = "商品名", name = "productName", example = "商品名")
    private String productName;

    @ApiModelProperty(value = "商品规格", name = "specification", example = "商品规格")
    private String specification;

    @ApiModelProperty(value = "评价得分", name = "evaluateScore", example = "评价得分")
    private String evaluateScore;

    @ApiModelProperty(value = "评价内容", name = "evaluateContent", example = "评价内容")
    private String evaluateContent;
    
    @ApiModelProperty(value = "评价图片", name = "evaluatePicture", example = "评价图片")
    private String evaluatePicture;
}
