package com.bizvane.members.facade.service.api361;

import com.bizvane.members.facade.es.pojo.IntegralInfoSearchPojo;
import com.bizvane.members.facade.models.MemberIntegralRecord361VO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * <p>
 * 361积分记录查询接口
 * </p>
 * @author ljc
 * @since 2020/05/15
 */
@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface IntegralRecord361ApiService {

    /**
     * 积分变动操作
     * @param vo
     * @return
     */
    @PostMapping("/api/integralRecord361/getIntegralRecord")
    ResponseData<PageInfo<IntegralInfoSearchPojo>> getIntegralRecord(@RequestBody MemberIntegralRecord361VO vo);

}
