package com.bizvane.members.facade.utils;

import com.bizvane.utils.jacksonutils.JacksonUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

@Slf4j
@MappedJdbcTypes(JdbcType.VARCHAR)
@MappedTypes(String.class)
public class EncryptCardNoTypeHandler extends BaseTypeHandler<String> {

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, String parameter, JdbcType jdbcType) throws SQLException {
        try {
            Long localCompanyId = CryptoCardNoPlugin.getLocalCompanyId();
            Method localMethod = CryptoCardNoPlugin.getLocalMethod();
            // 如果是加密操作，且brandId为空，打印日志用于排查
            if (localCompanyId == null) {
                log.error("encrypt phone brandId is null EncryptPhoneTypeHandler parameter: {}, method: {}", parameter, JacksonUtil.bean2Json(localMethod));
            }
            boolean needEncrypt = CryptoCardNoPlugin.needEncrypt();
            if (needEncrypt) {
                parameter = PhoneEncryptConfig.encryptAES(localCompanyId, parameter);
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        ps.setString(i, parameter);
    }

    @Override
    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String value = rs.getString(columnName);
        try {
            Long localCompanyId = CryptoCardNoPlugin.getLocalCompanyId();
            boolean needEncrypt = CryptoCardNoPlugin.needEncrypt();
            if (needEncrypt) {
                value = PhoneEncryptConfig.decryptAES(localCompanyId, value);
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return value;
    }

    @Override
    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String value = rs.getString(columnIndex);
        try {
            Long localCompanyId = CryptoCardNoPlugin.getLocalCompanyId();
            boolean needEncrypt = CryptoCardNoPlugin.needEncrypt();
            if (needEncrypt) {
                value = PhoneEncryptConfig.decryptAES(localCompanyId, value);
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return value;
    }

    @Override
    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String value = cs.getString(columnIndex);
        try {
            Long localCompanyId = CryptoCardNoPlugin.getLocalCompanyId();
            boolean needEncrypt = CryptoCardNoPlugin.needEncrypt();
            if (needEncrypt) {
                value = PhoneEncryptConfig.decryptAES(localCompanyId, value);
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return value;
    }
}
