package com.bizvane.members.facade.models;

import com.bizvane.members.facade.utils.EncryptCardNo;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author zcc
 * @date 2022/2/17 11:46
 **/
@Data
@EncryptCardNo
public class MbrRechargeCardVo implements Serializable {

    private static final long serialVersionUID = 6894493752078718408L;

    /**
     * 主键
     */
    private Long mbrRechargeCardId;

    /**
     * 企业id
     */
    private Long sysCompanyId;

    /**
     * 品牌id
     */
    private Long sysBrandId;

    /**
     * 会员memberCode
     */
    private String memberCode;

    /**
     * 储值卡归属类型 1.品牌 2.运营组织
     */
    private Integer cardSourceType;

    /**
     * 储值卡号
     */
    @EncryptCardNo
    private String petCardNo;

    /**
     * 余额
     */
    private BigDecimal balance;

    /**
     * 储值卡归属线上组织code
     */
    private String organizationCode;

    /**
     * 储值卡归属线上组织名称
     */
    private String organizationName;


    /**
     * 余额修改日期
     */
    private Date offlineUpdateBalanceDate;



}
