package com.bizvane.members.facade.service.inner;


import com.bizvane.customized.facade.models.vo.ur.CancelPaidMemberRequestVo;
import com.bizvane.members.facade.vo.*;

import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;

import javax.servlet.http.HttpServletRequest;


public interface PaidMemberService {
    /**
     * 获取付费会员列表
     * @param requestVo
     * @param
     * @return
     */
    ResponseData<PageInfo<PaidMemberResponseVO>> getPaidMemberList(PaidMemberRequestVO requestVo, SysAccountPO sysAccountPO);

    /**
     * 导出付费会员列表
     * @param requestVo
     * @param
     * @return
     */
    ResponseData exportPaidMemberList(PaidMemberRequestVO requestVo, HttpServletRequest request);

    /**
     * 退卡
     * @param refundVo
     * @param sysAccountPO
     * @return
     */
    ResponseData  paidMemberRefund(PaidMemberRefundVO refundVo, SysAccountPO  sysAccountPO);

    /**
     * 退款回调
     * @param callbackVO
     * @return
     */
    ResponseData paidMemberRefundCallback(PaidMemberRefundCallbackVO callbackVO);

    /**
     * 取消退款
     * @param refundVo
     * @param sysAccountPO
     * @return
     */
    ResponseData cancelPaidMemberRefund(CancelPaidMemberRequestVo refundVo, SysAccountPO  sysAccountPO);



}
