package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.vo.AutoLabelGroupRespVo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

import java.util.List;

/**
 * 自动标签分组service
 *
 * @author <a href="mailto:im.leexiao@gamil.com">KitAndrew</a>
 * @since 2020年11月03日 17:46:00
 */
public interface AutoLabelGroupService {
    /**
     * 查询自动标签分组
     *
     * @param sysCompanyId 企业id
     * @param brandId      品牌id
     * @return
     */
    ResponseData<List<AutoLabelGroupRespVo>> selectAutoLabelGroups(Long sysCompanyId, Long brandId);

    /**
     * 新增自动标签分组
     *
     * @param autoLabelGroupName 自动标签分组
     * @param sysAccountPo       当前登录人信息
     * @return
     */
    ResponseData<String> addAutoLabelGroup(String autoLabelGroupName, SysAccountPO sysAccountPo);

    /**
     * 修改自动标签分组
     * @param autoLabelGroupName
     * @param autoLabelGroupId
     * @param sysAccountPo
     * @return
     */
    ResponseData<String> updateAutoLabelGroup(String autoLabelGroupName, Long autoLabelGroupId, SysAccountPO sysAccountPo);

    /**
     * 删除自动标签分组
     * @param autoLabelGroupId
     * @param sysAccountPo
     * @return
     */
    ResponseData<String> deleteAutoLabelGroup(Long autoLabelGroupId, SysAccountPO sysAccountPo);
}
