package com.bizvane.members.facade.es.pojo;


import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.format.annotation.DateTimeFormat;

import org.springframework.data.annotation.Id;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode
@Document(indexName = "t_mbr_integral_record", type = "doc")
public class IntegralInfoSearchPojo implements Serializable {

    @Id
    @ApiModelProperty(value = "积分流水id", name = "integralRecordId", example = "积分流水id")
    private Integer mbrIntegralRecordId;

    @ApiModelProperty(value = "企业id", name = "sysCompanyId", example = "企业id")
    private Long sysCompanyId;

    @ApiModelProperty(value = "品牌id", name = "brandId", example = "品牌id")
    private Long brandId;

    @ApiModelProperty(value = "流水编号", name = "recordCode", example = "流水编号")
    private String recordCode;

    @ApiModelProperty(value = "会员code", name = "memberCode", example = "会员code")
    private String memberCode;

    @ApiModelProperty(value = "变更单据", name = "changeBills", example = "变更单据")
    private String changeBills;

    @ApiModelProperty(value = "变更积分", name = "changeIntegral", example = "变更积分")
    private Integer changeIntegral;

    @ApiModelProperty(value = "变更时间", name = "changeDate", example = "变更时间")
    private Date changeDate;

    @ApiModelProperty(value = "变更类型", name = "changeWay", example = "变更类型")
    private String changeWay;

    @ApiModelProperty(value = "变更详情", name = "changeDetails", example = "变更详情")
    private String changeDetails;

    @ApiModelProperty(value = "业务类型", name = "businessWay", example = "业务类型")
    private String businessWay;

    @ApiModelProperty(value = "积分有效期", name = "effetiveTime", example = "积分有效期")
    private Date effectiveTime;

    @ApiModelProperty(value = "会员姓名", name = "memberName")
    private String memberName;

    @ApiModelProperty(value = "线下企业code", name = "companyCode", example = "线下企业code")
    private String offlineCompanyCode;

    @ApiModelProperty(value = "线下品牌code", name = "brandCode", example = "线下品牌code")
    private String offlineBrandCode;

    @ApiModelProperty(value = "线下积分流水id", name = "offlineIntegralId", example = "线下积分流水id")
    private String offlineIntegralId;

    @ApiModelProperty(value = "线下会员id", name = "erpId", example = "线下会员id")
    private String erpId;

    @ApiModelProperty(value = "会员卡号", name = "memberCardNo")
    private String memberCardNo;

    @ApiModelProperty(value = "业务类型描述", name = "businessDescription")
    private String businessDescription;

    @ApiModelProperty(value = "线下门店code", name = "offlineStoreCode", example = "线下门店code")
    private String offlineStoreCode;

    @ApiModelProperty(value = "线下积分类型",name = "businessWayOffline")
    private String businessWayOffline;

}
