package com.bizvane.members.facade.models;

import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/16.
 * 消费记录
 */
@Data
@NoArgsConstructor
@Table(name="t_mbr_consume_record")
public class ConsumeRecordModel extends BaseModel implements Serializable{


    private static final long serialVersionUID = -6590368922257975070L;

    /**
     * //主键id
     */
    @Id
    private Integer consumeId;
    /**
     * //会员code
     */
    private String memberCode;
    /**
     * //订单号
     */
    private String orderNo;
    /**
     * //交易渠道
     */
    private String tradeChannel;
    /**
     * //门店名称
     */
    private String storeName;
    /**
     * //商品ids
     */
    private String goodsIds;
    /**
     * //订单详情
     */
    private String orderDetail;
    /**
     * //总额
     */
    private BigDecimal totalPrices;
    /**
     * //使用积分
     */
    private Integer useIntegral;
    /**
     * //订单时间
     */
    private Date orderTime;
}

