package com.bizvane.members.facade.service.datafetch.model;

import com.bizvane.members.facade.utils.EncryptCardNo;
import com.bizvane.members.facade.utils.EncryptPhone;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: houkai
 * @Date: 2018/8/10 11:04
 * @Description:会员订单取数对象
 */
@Data
@EncryptPhone
public class MemberOrderFetchModel extends BaseFetchModel implements Serializable {

    private static final long serialVersionUID = -4877894487466350537L;

    private String orderNo; // 订单号

    private String originalOrderNo;//退单时的原单号

    private Integer orderFrom; //订单来源1:线下零售单2：微商城

    private Integer orderType; //订单类型,1.商城订单,2.积分订单

    private Integer usedIntegral; //使用积分

    private Integer getedIntegral; // 获得积分

    private BigDecimal preferentialAmount; //优惠金额

    private BigDecimal deductibleAmount; //抵扣金额

    private BigDecimal commodityAmount; //商品金额 成交总额（吊牌价总额）

    private BigDecimal tradeAmount; //成交金额(优惠卷+抵扣卷+打折)

    private BigDecimal otherPreferentialVolume; //其他优惠卷金额(满减 满包邮)

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date placeOrderTime; //下单时间

    private Integer placeOrderCount;    //下单数量

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date payTime; //支付时间

    private BigDecimal payMoney; //支付金额

    private Integer productCount; //商品数量

    private String logisticsName; // 物流公司(关联到物流公司)

    @EncryptPhone
    private String consigneePhone; //收货人的手机

    @EncryptCardNo
    private String consigneeName; //收货人的姓名信息

    @EncryptCardNo
    private String consigneeDetailed; //收货人的详细地址

    private String consigneeProvince; // 收货人的省份

    private String consigneeCity; // 收货人的城市

    private String consigneeArea; //收货人的区

    private String consigneeStreet; //收货人的街道号

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date comfirmTime; //确认收货时间

    private Integer unsigned; //deliveredCount; //已发货数量

    private BigDecimal postage; //邮费(不包邮应收金额)

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date sendTime; //发货时间

    private String couponNo; //关联优惠券

    private String serviceStoreCode; //订单门店code

    private String serviceStoreName; //订单门店名

    private String serviceStoreSite; //订单门店地址

    private String serviceGuideName; //订单门店导购name

    private Integer freePostage; //是否包邮1:包邮,2自费

    private Integer evaluateStatus; //评价状态:1=未评价;2=已评价;3=已退货

    private String sendStoreName; //发货门店

    private Integer valid; //数据有效性：1=有效；0=无效

    private String remark; //备注

    private String offlineServiceGuideProportions;  //订单导购比例

    private String offlineServiceGuideCodes;        //订单导购id

    private String offlineServiceGuideNames;       //订单导购姓名

    private String billTime;        //账单时间

}
