package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MbrIntegralTransferModel;

import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface MemberIntegralTransferService {

	/**
	 * 提交积分转赠信息
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "/api/addIntegralTransfer", method = RequestMethod.POST)
	ResponseData<String> addIntegralTransfer(@RequestBody MbrIntegralTransferModel model);



	/**
	 * 领取积分
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "/api/integralRecipient", method = RequestMethod.POST)
	ResponseData<String> integralRecipient(@RequestBody MbrIntegralTransferModel model);
}
