package com.bizvane.members.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: houkai
 * @Date: 2018/7/20 13:56
 * @Description:
 */
@Data
@NoArgsConstructor
public class RegionModel implements Serializable {

    private static final long serialVersionUID = -9075917398481445452L;

    @ApiModelProperty(value = "城市编号", name = "code", example = "城市编号")
    private Integer code;

    @ApiModelProperty(value = "父城市编号", name = "parentCode", example = "父城市编号")
    private Integer parentCode;

    @ApiModelProperty(value = "类型", name = "type", example = "类型")
    private Byte type;

    @ApiModelProperty(value = "城市名称", name = "name", example = "城市名称")
    private String name;

    @ApiModelProperty(value = "城市全称", name = "fullName", example = "城市全称")
    private String fullName;

    @ApiModelProperty(value = "子节点", name = "fullName", example = "子节点")
    private List<RegionModel> children;
}
