package com.bizvane.members.facade.enums.alipay.electcard;

public enum AlipayElectCardTemplateActionInfoUrlTypeEnum {

    URL("1","url","对应填写url参数，支持http(s)和支付宝schema地址等"),
    MINI_APP_URL("0","miniAppUrl","对应填写mini_app_url参数，跳转至指定的支付宝小程序页面")
    ;

    private String type;
    private String code;
    private String msg;

    AlipayElectCardTemplateActionInfoUrlTypeEnum(String type, String code, String msg) {
        this.type = type;
        this.code = code;
        this.msg = msg;
    }

    public String getType() {
        return type;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public static String getUrlTypeCode(String type) {
        for (AlipayElectCardTemplateActionInfoUrlTypeEnum actionInfoUrlTypeEnum : AlipayElectCardTemplateActionInfoUrlTypeEnum.values()) {
            if (actionInfoUrlTypeEnum.getType().equals(type)) {
                return actionInfoUrlTypeEnum.getCode();
            }
        }

        return AlipayElectCardTemplateActionInfoUrlTypeEnum.URL.getCode();
    }
}
