package com.bizvane.members.facade.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

/**
 * @Author: dingshichen
 * @Date: 291-11-14
 * @Description: 商帆标准积分调整业务类型
 */
public enum BizvaneBusinessTypeEnum {
    /**
     * 积分过期
     */
    INTEGER_PAST_DUE("bizvane-1", "积分过期"),
    /**
     * 保留原积分
     */
    INTEGER_RESERVE("bizvane-2", "保留原积分"),
    /**
     * 积分清零
     */
    INTEGER_REST("bizvane-3", "积分清零"),
    /**
     * 手动调整支出
     */
    INTEGER_ADJUST_EXPEND("bizvane-4", "手动调整支出"),
    /**
     * 手动调整获取
     */
    INTEGER_ADJUST_INCOME("bizvane-5", "手动调整获取"),
    /**
     * 商品消费获取
     */
    INTEGER_CONSUME_INCOME("bizvane-6", "商品消费获取"),
    /**
     * 积分兑换支出
     */
    INTEGER_EXCHANGE_EXPEND("bizvane-7", "积分兑换支出"),
    /**
     * 游戏消耗支出
     */
    INTEGER_GAME_EXPEND("bizvane-8", "游戏消耗支出"),
    /**
     * 开卡活动
     */
    ACTIVITY_TYPE_REGISGER("bizvane-9", "开卡活动"),
    /**
     * 智能营销活动
     */
    ACTIVITY_TYPE_SMART("bizvane-10", "智能营销活动"),
    /**
     * 升级活动
     */
    ACTIVITY_TYPE_UPGRADE("bizvane-11", "升级活动"),
    /**
     * 扫码领券活动
     */
    ACTIVITY_TYPE_QRCODE("bizvane-12", "扫码领券活动"),
    /**
     * 手动领券活动
     */
    ACTIVITY_TYPE_MANUAL("bizvane-13", "手动领券活动"),
    /**
     * 消费活动
     */
    ACTIVITY_TYPE_ORDER("bizvane-14", "消费活动"),
    /**
     * 签到活动
     */
    ACTIVITY_TYPE_SIGNIN("bizvane-15", "签到活动"),
    /**
     * 生日活动
     */
    ACTIVITY_TYPE_BIRTHDAY("bizvane-16", "生日活动"),
    /**
     * 完善资料任务
     */
    TASK_TYPE_PREFECT("bizvane-17", "完善资料任务"),
    /**
     * 微信分享任务
     */
    TASK_TYPE_SHARE("bizvane-18", "微信分享任务"),
    /**
     * 消费金额任务
     */
    TASK_TYPE_COMSUMPTION_MONEY("bizvane-19", "消费金额任务"),
    /**
     * 消费次数任务
     */
    TASK_TYPE_COMSUMPTION_COUNT("bizvane-20", "消费次数任务"),
    /**
     * 邀请开卡任务
     */
    TASK_TYPE_INVITATION_OPENCARD("bizvane-21", "邀请开卡任务"),
    /**
     * 纪念日活动
     */
    TASK_TYPE_MEMORIAL_DAY("bizvane-22", "纪念日活动"),
    /**
     * 评价奖励活动
     */
    TASK_TYPE_EVALUATE_AWARD("bizvane-23", "评价奖励活动"),
    /**
     * 线下手动调整
     */
    OFFLINE_HAND_TYPE("bizvane-24", "线下手动调整"),
    /**
     * 线下活动调整
     */
    OFFLINE_ACTIVITY_TYPE("bizvane-25", "线下活动调整"),
    /**
     * 积分兑换券
     */
    INTEGRAL_EXCHANGE_COUPON("bizvane-26", "积分兑换券"),
    /**
     * 转盘活动
     */
    SOCIAL_AFFAIR("bizvane-27", "转盘活动"),
    /**
     * 红包膨胀活动
     */
    RED_PACKET_EXPAND_ACTIVIEY("bizvane-28", "红包膨胀活动"),
    /**
     * 砸金蛋活动
     */
    SMASH_EGG_ACTIVITY("bizvane-29", "砸金蛋活动"),
    /**
     * 积分商城消费积分
     */
    INTEGRAL_MALL_CONSUME("bizvane-30", "积分商城消费积分"),
    /**
     * 积分商城返还积分
     */
    INTEGRAL_MALL_RETURN("bizvane-31", "积分商城返还积分"),
    /**
     * 首单开卡活动
     */
    ACTIVITY_FIRST_ORDER("bizvane-32", "首单开卡活动"),
    /**
     * 宝宝生日活动
     */
    ACTIVITY_BABY_BIRTH("bizvane-33", "宝宝生日活动"),
    /**
     * 兑换有赞积分
     */
    EXCHANGE_OTHER_CONSUME("bizvane-34", "兑换有赞积分"),
    /**
     * 微商城积分扣减
     */
    MICRO_MALL_DECREASE("bizvane-35", "微商城积分扣减"),
    /**
     * 微商城积分返还
     */
    MICRO_MALL_INCREASE("bizvane-36", "微商城积分返还"),
    /**
     * 积分补偿
     */
    COMPENSATION_INTEGRAL("bizvane--1", "积分补偿"),
    /**
     * 摇一摇
     */
    SHAKE_AND_SHAKE("bizvane-37", "摇一摇"),
    /**
     * 储值送礼
     */
    RECHARGE_SEND_GIFT("bizvane-38", "储值送礼"),

    /**
     * 佣金兑换
     */
    COMMISSION_EXCHANGE("bizvane-39","佣金兑换"),
    /**
     * 天猫消费积分
     */
    GIFT_EXCHANGE("bizvane-40","天猫消费积分"),
    ///ur
    /**
     * 赠送
     */
    UR_GIVE_AWAY("bizvane-100", "赠送"),
    /**
     * 消费
     */
    UR_CONSUME("bizvane-101", "消费"),
    /**
     * 退货
     */
    UR_SALES_RETURN("bizvane-102", "退货"),
    /**
     * 积分调整减积分
     */
    UR_ADJUST_DECREASE("bizvane-103", "积分调整减积分"),
    /**
     * 积分调整增积分
     */
    UR_ADJUST_INCREASE("bizvane-104", "积分调整增积分"),
    /**
     * 积分兑换
     */
    UR_EXCHANGE("bizvane-105", "积分兑换"),
    /**
     * 积分抵现
     */
    UR_CASH("bizvane-106", "积分抵现"),
    /**
     * 积分抵现返还
     */
    UR_CASH_RETURN("bizvane-107", "积分抵现返还"),
    /**
     * 积分清零
     */
    UR_ZERO("bizvane-108", "积分清零"),
    /**
     * 赠送退回
     */
    UR_RETURN("bizvane-109", "赠送退回"),
    /**
     * 其它
     */
    UR_OTHER("bizvane-110", "其它"),
    /**
     * 百胜初始建档
     */
    BAISON_INITIAL_FILE("bizvane-113", "初始建档"),
    /**
     * 百胜积分调整
     */
    BAISON_POINTS_ADJUSTMENT("bizvane-114", "积分调整"),
    /**
     * 百胜充值积分
     */
    BAISON_RECHARGE_POINTS("bizvane-115", "充值积分"),
    /**
     * 调查问卷任务
     */
    TASK_TYPE_QUESTIONNAIRE("bizvane-42", "调查问卷任务");

    private String code;

    private String msg;

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    BizvaneBusinessTypeEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    /**
     * 根据枚举code获得枚举msg
     *
     * @param code
     * @return
     */
    public static String getBusinessTypeMessage(String code) {
        for (BizvaneBusinessTypeEnum type : BizvaneBusinessTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                return type.getMsg();
            }
        }
        return "";
    }

    /**
     * 根据枚举code获得枚举
     *
     * @param code
     * @return
     */
    public static BizvaneBusinessTypeEnum getBusinessTypeEnum(String code) {
        for (BizvaneBusinessTypeEnum type : BizvaneBusinessTypeEnum.values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    /**
     * 将该枚举全部转化成json
     *
     * @return
     */
    public static JSONArray toJson() {
        JSONArray jsonArray = new JSONArray();
        for (BizvaneBusinessTypeEnum e : BizvaneBusinessTypeEnum.values()) {
            JSONObject object = new JSONObject();
            object.put("typeId", e.getCode());
            object.put("typeName", e.getMsg());
            jsonArray.add(object);
        }
        return jsonArray;
    }
}
