package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MbrLevelModel;
import com.bizvane.members.facade.models.MembersSysModel;
import com.bizvane.members.facade.models.po.MbrLevelDefGoodsRulePO;
import com.bizvane.members.facade.models.po.MbrLevelRechargeRecordPO;
import com.bizvane.members.facade.vo.*;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.util.List;

/**
 * @Author: houkai
 * @Date: 2018/7/18 15:56
 * @Description:会员等级接口
 */
@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface MemberLevelApiService {

    /**
     * 查询品牌下排序等级列表
     *
     * @param brandId
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/queryLevelList", method = RequestMethod.POST)
    List<MbrLevelModel> queryLevelList(@RequestParam("brandId") Long brandId) throws MemberException;

    /**
     * 查询品牌下所有等级列表
     *
     * @param brandId
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/queryAllLevelList", method = RequestMethod.POST)
    ResponseData<List<MbrLevelModel>> queryAllLevelList(@RequestParam("brandId") Long brandId) throws MemberException;

    /**
     * 根据等级id查询上一级等级
     *
     * @param mbrLevelId
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/queryOnLevel", method = RequestMethod.POST)
    ResponseData<MbrLevelModel> queryOnLevel(@RequestParam("mbrLevelId") Long mbrLevelId) throws MemberException;

    /**
     * 根据等级id查询高一级等级
     *
     * @param mbrLevelId
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/queryHighLevel", method = RequestMethod.POST)
    ResponseData<MbrLevelModel> queryHighLevel(@RequestParam("mbrLevelId") Long mbrLevelId) throws MemberException;

    /**
     * 查询等级信息
     *
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/queryLevelModel", method = RequestMethod.POST)
    ResponseData<MbrLevelModel> queryLevelModel(@RequestParam(value = "mbrLevelId") Long mbrLevelId) throws MemberException;

    /**
     * 查询会员等级商品规则
     * @param mbrLevelId
     * @return
     */
    @RequestMapping(value = "/api/queryLevelGoodsRuleList", method = RequestMethod.POST)
    ResponseData<List<MbrLevelDefGoodsRulePO>> queryLevelGoodsRuleList(@RequestParam(value = "mbrLevelId") Long mbrLevelId);


    /**
     * 查询等级信息 baison
     *
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/queryLevelIdByCode", method = RequestMethod.POST)
    ResponseData<MbrLevelModel> queryLevelIdByCode(@RequestBody MbrLevelModel mbrLevelModel) throws MemberException;

    /**
     * 修改等级(只修改等级说明)
     *
     * @param mbrLevelModel
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/updateLevel", method = RequestMethod.POST)
    ResponseData updateLevel(@RequestBody MbrLevelModel mbrLevelModel) throws MemberException;

    /**
     * 查询品牌会员卡体系
     *
     * @param brandId
     * @return
     */
    @RequestMapping(value = "/api/queryMemberSys", method = RequestMethod.POST)
    ResponseData<MembersSysModel> queryMemberSys(@RequestParam("brandId") Long brandId);


    @RequestMapping(value = "/api/queryMbrLevelCalcIntegral", method = RequestMethod.POST)
    ResponseData<MbrLevelCalcIntegralResponseVo> queryMbrLevelCalcIntegral(@RequestBody @Valid MbrLevelCalcIntegralRequestVo mbrLevelCalcIntegralRequestVo);

    @RequestMapping(value = "/api/queryLevelIdByOfflineCode", method = RequestMethod.POST)
    ResponseData<Long> queryLevelIdByOfflineCode(@RequestParam("offlineLevelCode") String offlineLevelCode, @RequestParam("brandId") Long brandId);

    @RequestMapping(value = "/api/queryPayLevelCard",method = RequestMethod.POST)
    ResponseData<PayLevelCardResponseVO> queryPayLevelCard(@RequestBody @Valid PayLevelCardRequestVO payLevelCardRequestVO);

    @RequestMapping(value = "/api/judgePayLevelCard",method = RequestMethod.POST)
    ResponseData<Boolean> judgePayLevelCard(@RequestParam("sysCompanyId")Long sysCompanyId,@RequestParam("brandId")Long brandId);

    /**
     * 批量查询等级列表
     *
     * @param mbrLevelIds
     * @return
     * @throws MemberException
     */
    @RequestMapping(value = "/api/queryLevelListByIds", method = RequestMethod.POST)
    ResponseData<List<MbrLevelModelVo>> queryLevelListByIds(@RequestBody List<Long> mbrLevelIds);

    @RequestMapping(value = "/api/queryLevelRechargeRrcord", method = RequestMethod.POST)
    ResponseData<List<MbrLevelRechargeRecordPO>> queryLevelRechargeRrcord(@RequestParam("brandId") Long brandId,
                                                                          @RequestParam("memberCode") String memberCode,
                                                                          @RequestParam("cardNo") String cardNo);
}
