package com.bizvane.members.facade.utils;

import org.apache.commons.lang3.StringUtils;

/**
 * 脱敏工具类
 * @author huangxinliu
 * @date: 2021/1/25 10:00
 */
public class DesensitizeUtil {

    /** 从第几位开始脱敏 */
    public static final int DESENSITIZE_BEGIN = 3;
    /** 脱敏位数 */
    public static final int DESENSITIZE_LENTH = 4;
    /** 脱敏替换字符串 */
    public static final String DESENSITIZE_CHAR = "*";

    public static String encrypt(String content){
        if (StringUtils.isNotBlank(content)) {
            if(content.length() >= DESENSITIZE_BEGIN){
                String str = StringUtils.left(content, DESENSITIZE_BEGIN);
                int len = Math.min(content.length(), DESENSITIZE_BEGIN + DESENSITIZE_LENTH);
                str = StringUtils.rightPad(str, len, DESENSITIZE_CHAR).concat(StringUtils.right(content, content.length() - len));
                return str;
            }
        }
        return content;
    }

    public static String encrypt(String content, Integer desensitizeBegin, Integer desensitizeLength){
        if (StringUtils.isNotBlank(content)) {
            if(content.length() >= desensitizeBegin){
                String str = StringUtils.left(content, desensitizeBegin);
                int len = Math.min(content.length(), desensitizeBegin + desensitizeLength);
                str = StringUtils.rightPad(str, len, DESENSITIZE_CHAR).concat(StringUtils.right(content, content.length() - len));
                return str;
            }
        }
        return content;
    }

}
