package com.bizvane.members.facade.service.card.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 微信端、小程序、扫二维码、 开卡注册成功 返回响应信息
 */
@Data
@EqualsAndHashCode
public class ResponseOpenCardModel {

    @ApiModelProperty(name = "appId", value = "appId")
    private String appId;

    @ApiModelProperty(name = "unionId",value = "unionId")
    private String unionId;

    @ApiModelProperty(name = "openId", value = "openId")
    private String openId;

    @ApiModelProperty(name = "wxNick", value = "微信昵称")
    private String wxNick;

    @ApiModelProperty(name = "headPortraits", value = "微信头像")
    private String headPortraits;

    @ApiModelProperty(name = "levelName", value = "等级名称")
    private String levelName;

    @ApiModelProperty(name = "countIntegral", value = "累计可用积分")
    private Integer countIntegral;

    @ApiModelProperty(name = "cardNo", value = "线上卡号")
    private String cardNo;

    @ApiModelProperty(name = "offlineCardNo", value = "线下卡号")
    private String offlineCardNo;

    @ApiModelProperty(name = "cardStatus", value = "绑卡状态：1绑卡、2未帮卡")
    private Integer cardStatus;

    @ApiModelProperty(name = "memberCode", value = "会员code")
    private String memberCode;

    @ApiModelProperty(name = "name", value = "姓名")
    private String name;

    @ApiModelProperty(name = "phone", value = "手机号")
    private String phone;

    @ApiModelProperty(name = "gender", value = "性别")
    private String gender;

    @ApiModelProperty(name = "birthday", value = "生日")
    private Date birthday;

    @ApiModelProperty(name = "province", value = "省份")
    private String province;

    @ApiModelProperty(name = "city", value = "城市")
    private String city;

    @ApiModelProperty(name = "county", value = "区县")
    private String county;

    @ApiModelProperty(name = "address", value = "详细地址")
    private String address;

    @ApiModelProperty(name = "openCardTime", value = "开发时间")
    private Date openCardTime;

    @ApiModelProperty(name = "operateType", value = "操作类型:1绑卡，2注册")
    private Integer operateType;

    @ApiModelProperty(name = "code", value = "响应code")
    private Integer code;

    @ApiModelProperty(name = "message", value = "响应信息")
    private String message;

    @ApiModelProperty(name = "inviteRegisterTime",value = "注册时间")
    private String inviteRegisterTime;

    @ApiModelProperty(name = "cardNumber", value = "会员卡号")
    private String cardNumber;

    @ApiModelProperty(name = "nowLevelMember",value = "会员等级")
    private String nowLevelMember;

    @ApiModelProperty(name = "storesName",value = "门店")
    private String storesName;
    
    @ApiModelProperty(value = "开卡导购id", name = "openCardGuideId")
    private Long openCardGuideId;
    
    @ApiModelProperty(value = "服务导购id", name = "serviceGuideId")
    private Long serviceGuideId;

    @ApiModelProperty(value = "服务店铺id",name = "serviceStoreId")
    private Long serviceStoreId;

    private String erpId;

    private Long levelId;

    private String userId;

    private String bizCardNo;

}
