package com.bizvane.members.facade.enums;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/8/13.
 */
public enum OpenCardChannelEnum {
    /**
     * 会员开卡绑卡渠道 线下渠道
     */
    OFFLINE_CHANNEL(1L, "线下渠道"),
    /**
     * 会员开卡绑卡渠道 微信渠道
     */
    WECHAT_CHANNEL(2L, "微信渠道"),
    /**
     * 会员开卡绑卡渠道 负微信渠道
     * 场景:微信开卡渠道,会员解绑时,避免该字段空指针,开卡设置为默认值,再绑卡时用到
     */
    WECHAT_NEGATIVE_CHANNEL(-2L, "负微信渠道"),
    /**
     * 会员开卡绑卡渠道 支付宝渠道
     */
    ALIPAY_CHANNEL(3L, "支付宝渠道"),
    /**
     * 会员开卡绑卡渠道 天猫渠道
     */
    TAOBAO_CHANNEL(4L, "天猫渠道"),
    /**
     * 会员开卡绑卡渠道 电子会员卡渠道
     */
    ELECTCARD_CHANNEL(5L, "电子会员卡渠道"),
    /**
     * 会员开卡绑卡渠道 微商城
     */
    MALL(6L, "微商城"),
    /**
     * 会员开卡绑卡渠道 手动导入渠道
     */
    IMPORT_CHANNEL(7L, "手动导入渠道"),
    /**
     * 会员开卡绑卡渠道 微盟商城
     */
    MALL_WEIMOB_CHANNEL(8L, "微盟商城"),
    /**
     * 会员开卡绑卡渠道 EHR
     */
    EHR(9L,"EHR"),
    /**
     * 会员开卡绑卡渠道 其它渠道
     */
    OTHER_CHANNEL(10L,"其它渠道"),
    /**
     * 会员开卡绑卡渠道 有赞渠道
     */
    YOUZAN_CHANNEL(11L,"有赞渠道"),
    /**
     * 会员开卡绑卡渠道 其它渠道
     */
    NANXUN_CHANNEL(12L,"南讯渠道");
    private Long code;

    private String msg;

    OpenCardChannelEnum(Long code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Long getCode() {
        return code;
    }

    public void setCode(Long code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }


    /**
     * 根据枚举code获得枚举msg
     *
     * @param code
     * @return
     */
    public static String getOpenCardChanneMessage(Long code) {
        for (OpenCardChannelEnum type : OpenCardChannelEnum.values()) {
            if (type.getCode().equals(code)) {
                return type.getMsg();
            }
        }
        return "";
    }
}
